/*
 * SaveEventsAction.h
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file SaveEventsAction.h The SaveEventsAction class declaration file */

#ifndef SAVEEVENTSACTION_H_
#define SAVEEVENTSACTION_H_

#include "../CollectionAction/CollectionAction.h"

/*! @brief An action that saves the selected events
 *
 * This action saves the selected events into a ROOT file.
 */
class SaveEventsAction: public CollectionAction {

public:
  /*! @brief Constructor.
   *
   * outOptions is to be passed as the argument of a PamLevel2::SetWhichTrees() call,
   * so it must be encoded in a compatible format. See the PamLevel2 documentation.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name, with path (absolute or relative).
   * @param outOptions The output options.
   */
  SaveEventsAction(const char *actionName, TString outFileName, TString outOptions = TString(""));

  /*! @brief Destructor */
  ~SaveEventsAction() {
  }

  /*! @brief The setup procedure.
   *
   * This routine will set the trees to be saved, by calling PamLevel2::SetWhichTrees().
   *
   * @param events The events pointer.
   */
  void Setup(PamLevel2 *events);

  /*! @brief Fills the tree with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the tree of saved events to the output file.  */
  void Finalize();

private:

  TFile *_outTreeFile;
  PamLevel2 *_events;
  TString _outOptions;
  TString _outFileName;
};

#endif /* SAVEEVENTSACTION_H_ */
